package com.worldline.information

import androidx.compose.foundation.layout.*
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.verticalScroll
import androidx.compose.material3.*
import androidx.compose.runtime.*
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.font.FontFamily
import androidx.compose.ui.unit.dp
import org.json.JSONArray
import org.json.JSONObject

@Composable
fun PaymentInfoScreen(paymentInfoJson: String, onRequestPaymentInfo: () -> Unit) {
    // Helper to pretty-print JSON
    fun prettyPrintJson(json: String): String {
        return try {
            when {
                json.trim().startsWith("{") -> JSONObject(json).toString(2)
                json.trim().startsWith("[") -> JSONArray(json).toString(2)
                else -> json
            }
        } catch (e: Exception) {
            json
        }
    }

    Column(
        modifier = Modifier
            .fillMaxSize()
            .padding(24.dp),
        verticalArrangement = Arrangement.Center,
        horizontalAlignment = Alignment.CenterHorizontally
    ) {
        Button(onClick = onRequestPaymentInfo) {
            Text("Request Payment Information")
        }
        Spacer(modifier = Modifier.height(24.dp))
        if (paymentInfoJson.isNotEmpty()) {
            Box(
                modifier = Modifier
                    .weight(1f)
                    .fillMaxWidth()
                    .verticalScroll(rememberScrollState())
            ) {
                Text(
                    text = prettyPrintJson(paymentInfoJson),
                    style = MaterialTheme.typography.bodySmall,
                    fontFamily = FontFamily.Monospace
                )
            }
        }
    }
}

